package ga.core.goperators;

import ga.core.individual.IIndividual;
import ga.core.validation.GAContext;

/**
 * Interface for a mutation operator.
 * 
 * @param <T>
 *          The generic type of individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IMutationOp<T extends IIndividual<T>> extends IGeneticOp {

  /**
   * Performs a mutation (if probability met) of the given individual and
   * returns the new individual.
   * 
   * @param individual
   *          Individual to mutate.
   * @param context
   *          The GA context.
   * @return Mutated individual.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public T mutate(T individual, GAContext context);

}
